/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.items;

import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentReflection;
import com.mujmajnkraft.bettersurvival.init.ModEnchantments;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.AdvancementCommand;
import net.minecraft.command.CommandException;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCustomShield
extends ItemShield {
    public float blockpower;
    private int weight;
    public static UUID weightModifierUUID = UUID.fromString("d6107045-134f-4c54-a645-75c3ae5c7a27");
    public static UUID knockbackModifierUUID = UUID.fromString("d6107045-134f-4c54-a645-75c0ae5c7a27");

    public ItemCustomShield(float blockpower, int weight) {
        this.field_77777_bU = 1;
        this.blockpower = blockpower;
        this.weight = weight;
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.func_77656_e(250 * weight);
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)ItemArmor.field_96605_cw);
    }

    public void applyModifiers(EntityLivingBase entity) {
        AttributeModifier KRmodifier = new AttributeModifier(knockbackModifierUUID, "shield_knockback_adjustment", 1.0, 0);
        if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.heavy, (ItemStack)entity.func_184607_cu()) > 0) {
            if (!entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_180374_a(KRmodifier)) {
                entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(KRmodifier);
            }
        } else {
            entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(KRmodifier);
        }
        int l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.weightless, (ItemStack)entity.func_184607_cu());
        int w = ((ItemCustomShield)entity.func_184607_cu().func_77973_b()).getWeight();
        float i = w - 2 * l >= 0 ? (float)(w - 2 * l) : 0.0f;
        double multiplyer = Math.pow(2.0, 1.0f - i) - 1.0;
        AttributeModifier speedmodifier = new AttributeModifier(weightModifierUUID, "shield_speed_adjustment", multiplyer, 2);
        if (!entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(speedmodifier)) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(speedmodifier);
        } else if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(weightModifierUUID).func_111164_d() != multiplyer) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(weightModifierUUID);
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(speedmodifier);
        }
    }

    public static boolean blockArrow(DamageSource source, EntityLivingBase defender) {
        if (ItemCustomShield.canBlockDamageSource(source, defender) && defender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)defender;
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            player.func_184607_cu().func_77972_a(1, (EntityLivingBase)player);
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                try {
                    ItemCustomShield.grantAdvancement(playerMP);
                }
                catch (CommandException e) {
                    e.printStackTrace();
                }
            }
            if (player.func_184607_cu().func_190926_b()) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
            return true;
        }
        return false;
    }

    public float getDamageBlocked(EntityLivingBase wielder, DamageSource source, float amount) {
        if (amount > 0.0f && ItemCustomShield.canBlockDamageSource(source, wielder)) {
            int l;
            if (!source.func_76363_c()) {
                Entity entity;
                int l2 = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.blockpower, (ItemStack)wielder.func_184607_cu());
                if (wielder instanceof EntityPlayer) {
                    this.damageShield(amount, (EntityPlayer)wielder);
                }
                amount *= (1.0f - this.blockpower) / (float)(1 + l2);
                if (!source.func_76352_a() && (entity = source.func_76364_f()) instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70653_a((Entity)wielder, 0.5f, wielder.field_70165_t - entity.field_70165_t, wielder.field_70161_v - entity.field_70161_v);
                    if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.reflection, (ItemStack)wielder.func_184607_cu()) > 0) {
                        EnchantmentReflection.reflectDamage(entity, wielder);
                    }
                }
            } else if (source.func_82725_o() && (l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.spellshield, (ItemStack)wielder.func_184607_cu())) > 0) {
                if (wielder instanceof EntityPlayer) {
                    this.damageShield(amount, (EntityPlayer)wielder);
                }
                amount *= 1.0f - this.blockpower * ((float)l / 3.0f);
            }
        }
        return amount;
    }

    public static boolean canBlockDamageSource(DamageSource damageSourceIn, EntityLivingBase entity) {
        Vec3d vec3d;
        if (entity.func_184607_cu().func_77973_b() instanceof ItemCustomShield && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            return vec3d2.func_72430_b(vec3d1) < 0.0;
        }
        return false;
    }

    void damageShield(float damage, EntityPlayer player) {
        if (damage >= 3.0f && player.func_184607_cu().func_77973_b() instanceof ItemCustomShield) {
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_77972_a(i, (EntityLivingBase)player);
            if (player.func_184607_cu().func_190926_b()) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    static void grantAdvancement(EntityPlayerMP playerMP) throws CommandException {
        AdvancementProgress progress = playerMP.func_192039_O().func_192747_a(AdvancementCommand.func_192551_a((MinecraftServer)playerMP.func_184102_h(), (String)"minecraft:story/deflect_arrow"));
        for (String s : progress.func_192107_d()) {
            playerMP.func_192039_O().func_192750_a(AdvancementCommand.func_192551_a((MinecraftServer)playerMP.func_184102_h(), (String)"minecraft:story/deflect_arrow"), s);
        }
    }

    public int func_77619_b() {
        return 30 - 5 * this.weight;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151042_j;
    }

    public int getWeight() {
        return this.weight;
    }
}

